/* AUFT27: */
/* wegen speichergrsse */
code=4000
domains
  fahrplan=fplan(integer,integer,integer,integer,integer)
  nummer=zug(integer)
  liste=symbol*
database - erreicht
  erreicht_db(integer,liste)
database - abfahrt
  abfahrt_db(integer)
database - frhest
  frhest_db(integer)    
predicates
  dic(symbol,symbol,fahrplan)
  ic(symbol,symbol,liste,liste,integer,nummer,integer,integer,integer,integer)
  umkehre(liste,liste)
  anfge(liste,liste,liste)
  ausgabe_listenelemente(liste)
  anfrage(symbol,symbol,integer)
  antwort(symbol,symbol,integer,liste,integer,integer)
  gleich(symbol,symbol)
  vergleich(integer,liste)
  anforderung
  anzeige
  bereinige_wiba
  start
  berechne_1(integer,integer,integer)
  berechne_2(integer,fahrplan)
  berechne_3(integer,integer,integer)
  eintrage(liste,integer,integer)
  run
clauses
dic(ha,k,fplan(3,0,00,7,43)).
dic(ha,k,fplan(30,12,00,20,43)).
dic(ha,fu,fplan(1,0,00,7,11)).
dic(ha,fu,fplan(10,12,00,20,11)).
dic(k,ka,fplan(2,7,43,13,08)).
dic(k,ka,fplan(20,20,43,3,08)).
dic(k,ma,fplan(3,7,43,10,48)).
dic(k,ma,fplan(30,20,43,0,48)).
dic(fr,m,fplan(4,11,26,18,40)).
dic(fr,m,fplan(40,23,26,7,40)).
dic(fr,st,fplan(3,11,26,14,53)).
dic(fr,st,fplan(30,2,26,6,53)).
dic(fu,m,fplan(1,7,11,13,45)).
dic(fu,m,fplan(10,20,11,3,45)).
dic(ma,fr,fplan(3,10,48,11,26)).
dic(ma,fr,fplan(30,0,48,2,26)).
dic(ka,st,fplan(5,13,08,13,39)).
dic(ka,st,fplan(50,1,08,2,39)).
dic(st,m,fplan(3,14,53,18,53)).
dic(st,m,fplan(30,6,53,11,53)).





ic(Von,Nach,Gesamt,Gesamt,Dist,zug(Nr),Frhest,D2,Warte,W2):-
  dic(Von,Nach,fplan(Nr,Ab_h,Ab_min,An_h,An_min)),
  berechne_1(Abfahrt,Ab_h,Ab_min),
  Frhest <= Abfahrt,
  eintrage(Gesamt,Abfahrt,Frhest),
  berechne_2(Fahr1,fplan(Nr,Ab_h,Ab_min,An_h,An_min)),
  Dist = Fahr1+D2,
  berechne_3(Warte1,Abfahrt,Frhest),
  Warte = Warte1+W2.



ic(Von,Nach,Basisliste,Ergebnis,Dist,zug(Nr),Frhest,D2,Warte,W2):-
  dic(Von,Z,fplan(Nr1,Ab_h,Ab_min,An_h,An_min)),
  berechne_1(Abfahrt,Ab_h,Ab_min),
  Frhest <= Abfahrt,
  eintrage(Basisliste,Abfahrt,Frhest),
  berechne_2(Fahr1,fplan(Nr1,Ab_h,Ab_min,An_h,An_min)),
  Dist2 = Fahr1+D2,
  berechne_3(Warte1,Abfahrt,Frhest),
  Warte2 = Warte1+W2,
  berechne_1(Frhest2,An_h,An_min),
  ic(Z,Nach,[Z|Basisliste],Ergebnis,Dist,zug(Nr2),
				    Frhest2,Dist2,Warte,Warte2).



eintrage([],Abfahrt,Frhest):-retractall(abfahrt_db(_)),
			      retractall(frhest_db(_)),
			      asserta(abfahrt_db(Abfahrt)),
			      asserta(frhest_db(Frhest)).
eintrage(Gesamt,Abfahrt,Frhest).


umkehre([],[]).
umkehre([Kopf|Rumpf],Ergebnis):-
       umkehre(Rumpf,Vorder_Liste),
       anfge(Vorder_Liste,[Kopf],Ergebnis).

anfge([],Hinter_Liste,Hinter_Liste).
anfge([Kopf|Rumpf],Hinter_Liste,[Kopf|Ergebnis]):-
       anfge(Rumpf,Hinter_Liste,Ergebnis).

berechne_1(Zeit,Zeit_h,Zeit_min):-
	 Zeit = Zeit_h * 60 + Zeit_min.

/* entweder oder, statt cut auch an_h < ab_h in 2. klausel */
berechne_2(Fahr,fplan(Nr,Ab_h,Ab_min,An_h,An_min)):-
	 An_h >= Ab_h,
	 Min_Ab = Ab_h * 60 + Ab_min,
	 Min_An = An_h * 60 + An_min,
	 Fahr = (Min_An - Min_Ab),
	 !.

berechne_2(Fahr,fplan(Nr,Ab_h,Ab_min,An_h,An_min)):-
	 /* An_h < Ab_h  */
	 Min_Ab = 24 * 60 - (Ab_h * 60 + Ab_min),
	 Min_An = An_h * 60 + An_min,
	 Fahr = Min_Ab + Min_An.


berechne_3(Warte,Abfahrt,Frhest):-
	 Abfahrt >= Frhest,
	 Warte = (Abfahrt - Frhest),
	 !.

berechne_3(Warte,Abfahrt,Frhest):-
	 Warte = Abfahrt + (24 * 60 - Frhest).

anforderung:-anfrage(Von,Nach,Frhest),
	  antwort(Von,Nach,Dist,Resultat_invers,Frhest,Warte),
	  abfahrt_db(Abfahrt),
	  frhest_db(Zeit),
	  Reisezeit = Dist + Warte - (Abfahrt - Zeit),
	  vergleich(Reisezeit,Resultat_invers),
	  fail.

anfrage(Von,Nach,Frhest):-write("Gib Abfahrtsort: "),nl,
	 readln(Von),
	 write("Gib Ankunftsort: "),nl,
	 readln(Nach),
	 not(gleich(Von,Nach)),
	 write("Gib Abfahrtsstunde: "),nl,
	 readint(Abfahrt_h),
	 write("Gib Abfahrtsminute: "),nl,
	 readint(Abfahrt_min),
	 berechne_1(Frhest,Abfahrt_h,Abfahrt_min).


gleich(X,X):-write("Abfahrtsort gleich Ankunftsort "),nl.

antwort(Von,Nach,Dist,Resultat_invers,Frhest,Warte):-
	ic(Von,Nach,[],Resultat,Dist,_,Frhest,0,Warte,0),
	umkehre(Resultat,Resultat_invers).


vergleich(Reisezeit,Resultat_invers):-
	      erreicht_db(Abstand,Liste),
	      Reisezeit < Abstand,
	      retract(erreicht_db(Abstand,Liste)),
	      asserta(erreicht_db(Reisezeit,Resultat_invers)).
vergleich(Reisezeit,Resultat_invers):-
	      not(erreicht_db(_,_)),
	      asserta(erreicht_db(Reisezeit,Resultat_invers)).

anzeige:-not(erreicht_db(_,_)),
	 write("IC-Verbindung existiert nicht "),nl.
anzeige:-erreicht_db(Abstand,Liste),
	 write(" IC-Verbindung existiert "),nl,
	 Reisezeit_h = Abstand div 60,
	 Reisezeit_min = (Abstand mod 60),
	 write(" Reisezeit "),write(Reisezeit_h),write(" h. "),
	 write(Reisezeit_min),write(" min. "),nl,
	 !,
	 not(Liste = []),
	 write(" Zwischenstationen: "),nl,
	 ausgabe_listenelemente(Liste),nl.

ausgabe_listenelemente([]).
ausgabe_listenelemente([Kopf|Rumpf]):-
	 write(Kopf),nl,
	 ausgabe_listenelemente(Rumpf).

bereinige_wiba:-retract(erreicht_db(_,_)),
		fail.
bereinige_wiba.

start:-anforderung.
start:-anzeige.


run:-bereinige_wiba,!,start.


